% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program TrueColorImage.m
[x,  y] = meshgrid(-128:127,  128:-1:-127);
r = sqrt(x.^2 + y.^2);
RI = 128 + (r <32 )*127 + (r >= 128)*127;
GI = 128 + (r >= 28 & r < 80)*127 + (r >= 128)*127;
BI = 128 + (r >= 72)*127;
M = cat(3,  RI,  GI,  BI)/255; % cat takes 3 2-dimensional 
                               % RGB matrices to create
                               % an image with 3 color planes
showImage(M,   ' ');
